 ; Ŀ
 ;   Lent - read a line from a .csv file into a block.                     
 ;   Copyright 2003 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Cdfbox - display a list of strings in a dialog box.        
 ;   Arguments: Fildat, the list.                                          
 ;              Filnam, the data file name.                                
 ;   Returns a text string.                                                
 ; 
 (DEFUN CDFBOX (fildat filnam / dcl_id num numf csvlin malist findx ret)
  (setq dcl_id (load_dialog "lent.dcl"))
  (new_dialog "lent" dcl_id)     ; must come before data for list box
 ; Ŀ
 ;   Make the csv line list for the list box.                              
 ; 
  (start_list "the_list")        ; read fildata into list box
  (setq num 0)
  (setq numf 0)                  ; lines in file
  (while (setq csvlin (nth num fildat))
         (if (/= (substr csvlin 1 1) ";")
             (progn
                  (setq numf (1+ numf))
                  (add_list csvlin)
                  (setq malist (cons csvlin malist))))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa numf) " line"
                              (if (= numf 1) "" "s")
                              " in file: " filnam))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (csvok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a csv string or nil.                                           
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Cdfbox end.                                                           
 ; 

 ; Ŀ
 ;   Cdfl: read a datafile into a list of strings.                         
 ;   Takes one argument, the file name.                                    
 ;   Returns a list containing either the contents of the file or - if     
 ;   it wasn't found - the name of the current drawing.                    
 ; 
 (DEFUN CDFL (fnam / fn filstr namlst cnam namm namls2)
 ; Ŀ
 ;   If the datafile can be opened then read the lines into a list.        
 ;   Ignore empty lines.                                                   
 ; 
  (if (setq fn (open fnam "r"))
      (progn
           (while (setq filstr (read-line fn))
                  (while (= (substr filstr 1 1) " ")
                         (setq filstr (substr filstr 2)))
                  (if (/= filstr "")
                      (setq namlst (append namlst (list filstr)))))
           (close fn)))
 namlst)
 ; Ŀ
 ;   Cdfl end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len llen pos name1 strlst)
 ; Ŀ
 ;   First knock off leading spaces.  This prevents a string consisting    
 ;   only of spaces from getting into the main loop and crashing.          
 ; 
  (while (and (= (substr linn 1 1) " ")
              (/= (strlen linn) 0))
         (setq linn (substr linn 2)))
 ; Ŀ
 ;   Now process the string.  Note that the space remover is still         
 ;   required for leading spaces in individual fields.                     
 ; 
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")   ; character to split on
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= 0 (setq llen (strlen name1)))
                     (= (substr name1 llen) " "))
                (setq name1 (substr name1 1 (1- llen))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Csvok - if OK was pressed, see if a string line was        
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN CSVOK (reason / lisval num str len)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a data line."))
 lisval)
 ; Ŀ
 ;   Csvok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Noovl - update an attribute depending on the value of a string.       
 ;   If the string is ## or "" then empty the attribute, if it is * then   
 ;   don't touch it, otherwise put the string into the attribute.          
 ;   Arguments: Entt, the entity data list for the attribute.              
 ;              Val, an attribute value.                                   
 ;   Returns nothing.                                                      
 ; 
 (DEFUN NOOVL (entt val /)
  (cond ((= val "##")
         (entmod (subst (cons 1 "") (assoc 1 entt) entt)))
        ((and val (/= val "*"))
         (entmod (subst (cons 1 val) (assoc 1 entt) entt))))
 (princ))
 ; Ŀ
 ;   Noovl end.                                                            
 ; 

 ; Ŀ
 ;   Refill - replace attribute values with new ones from a list.          
 ;   Arguments: Enam, a block insertion ename.                             
 ;              Atlis, a list of new attribute values.                     
 ;   Calls Noovl to update atts depending on the values from the file.     
 ;   Returns zilch.                                                        
 ; 
 (DEFUN REFILL (enam atlis / num entt)
  (setq num 0)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))))
         (noovl entt (nth num atlis))
         (setq num (1+ num)))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Refill end.                                                           
 ; 

 ; Ŀ
 ;   Lent.                                                                 
 ; 
 (DEFUN C:LENT (/ filnam dalisa enampt enam entt linn)
 ; Ŀ
 ;   Get a cdf file name.                                                  
 ; 
  (if (setq filnam (getfiled "Data File" "Cdata.csv" "" 12))
      (progn
 ; Ŀ
 ;   Read the cdf file into a list.                                        
 ; 
           (setq dalisa (cdfl filnam))
 ; Ŀ
 ;   Whlie blocks and data lines are selected...                           
 ; 
          (while (and (setq enampt (entsel "\nSelect a block: "))
                      (setq enam (car enampt))
                      (= (cdr (assoc 0 (entget enam))) "INSERT")
                      (setq linn (cdfbox dalisa filnam))
                      (/= linn ""))
                 (setq linn (csplit linn))
                 (refill enam linn)
                 (entupd enam))))
 (princ))